/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.common.util.test;

import com.ibm.hsc.common.util.HscCecLock;
import com.ibm.hsc.common.util.HscExclusiveLock;
import com.ibm.hsc.common.util.HscLockManager;
import com.ibm.hsc.common.util.test.TxObject;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;

public class TxWorker
extends Thread {
    private Socket m_socket;

    public TxWorker(Socket socket) {
        this.m_socket = socket;
    }

    public void run() {
        HscLockManager hscLockManager = HscLockManager.GetHscLockManager("TestLockMgr");
        HscCecLock hscCecLock = hscLockManager.getHscCecLock("cec");
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(this.m_socket.getOutputStream());
            ObjectInputStream objectInputStream = new ObjectInputStream(this.m_socket.getInputStream());
            TxObject txObject = (TxObject)objectInputStream.readObject();
            System.out.println("Client TxObject: " + txObject);
            int n = txObject.getLockType();
            String string = txObject.getCecName();
            long l = txObject.getDuration();
            hscCecLock.print();
            if (n >= 0 && n <= 2) {
                hscCecLock.Lock(n);
                Thread.currentThread();
                Thread.sleep(l);
                hscCecLock.Unlock();
            } else {
                if (!HscExclusiveLock.GetHscExclusiveLock().LockDirtyRead()) {
                    txObject.setMessage("Failed.");
                    objectOutputStream.writeObject(txObject);
                    objectOutputStream.flush();
                    this.m_socket.close();
                    return;
                }
                Thread.currentThread();
                Thread.sleep(l);
                HscExclusiveLock.GetHscExclusiveLock().UnlockDirtyRead();
            }
            txObject.setMessage("Done.");
            objectOutputStream.writeObject(txObject);
            objectOutputStream.flush();
            hscCecLock.print();
            System.err.println("Task finished");
        }
        catch (Exception exception) {
            hscCecLock.print();
            System.err.println(exception);
            System.err.println("Task failed");
        }
        try {
            this.m_socket.close();
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
    }
}

